* Retraitement base fiscale 1997

set more off
clear

global year=1997

******************************************************************************************************************
* Legislative parameters converted in macro
		import excel using "$datarev/Parametres_IR.xls", first clear sheet("Parametres")  cellrange(A1:F20)
			foreach var of varlist tauxmicro_fon-tauxbnc{
				quiet sum `var' if year==$year
				global `var'=r(mean)
		}		
***************************************************************************************************************



use "$datarev/rev$year.dta",clear
gen year=$year


* Ponderation
	gen pondn=pondv
	
* Caractristiques dmographiques
	* age
		gen age=year-aged
		replace age=20 if age <20 | age==.
	* Nombre de dclarants dans la dclaration
		gen ndecl=2
		replace ndecl=1 if agec==9999
	* age du conjoint
		gen temp=year-agec if agec~=9999
		replace temp=20 if temp<20
		drop agec
		rename temp agec
	* sexe: Avant dernire lettre du fip 3= homme, 4 =femme
		gen temp=substr(fip,-2,1)
		gen sexe=1 if temp=="3"
		replace sexe=2 if temp=="4"	
		drop temp
		
		
	* Structure demo des pac : 1997
		* Pour cette anne, les variables sont dj au format dsir
		local varlist = "AGE01 AGE02 AGE03 AGE04 AGE05 AGE06 AGE07 AGE08 AGE09 AGE10 AGE11 AGE12	"
		gen npac =0
		local i=0
		foreach var in `varlist'{
			local i=`i'+1
			replace npac=npac+1 if (`var' >0 & !missing(`var') )
			gen anaispac_`i'=`var' if (`var' >0 & !missing(`var') )	
		}
	
		/* verif
			quiet sum npac
			dis r(max)
			forval a=1/`r(max)' {
				sum anaispac_`a'
			}
			
		*/
		* Retraitement de l'anne de naissance vers age
			quiet sum npac
			forval a=1/`r(max)' {
				* Naissance arriv aprs l'anne de dclaration
					replace anaispac_`a'=year if anaispac_`a'~=. & anaispac_`a'>year
				* Il manque le 19 dans 19xx
				replace anaispac_`a'=anaispac_`a'+1900 if anaispac_`a'~=. & anaispac_`a'<100 & year-anaispac_`a'<2000
				* Il manque le 20 dans 20xx
				replace anaispac_`a'=anaispac_`a'+2000 if anaispac_`a'~=. & anaispac_`a'<100 & year-anaispac_`a'>=2000
				* Il manque le 1 dans 9xx
				replace anaispac_`a'=anaispac_`a'+1000 if anaispac_`a'~=. & anaispac_`a'<1000 & anaispac_`a'>800
				* Il manque le 9 dans 1xx
				replace anaispac_`a'=anaispac_`a'+1800 if anaispac_`a'~=. & anaispac_`a'<800 & anaispac_`a'>100
				replace anaispac_`a'=year-anaispac_`a' if anaispac_`a'~=. 
			}
			
	* situation matrimoniale : 
		* Code: 1= mari (M) ; 2 = clibataire (C), 3: Divorc (D),4: veuf (V), 6:pacs (O)
		* Avant 2002, le pacs n'existait pas
		gen temp="M" if mat==1
		replace temp="C" if mat==2
		replace temp="D" if mat==3
		replace temp="V" if mat==4
		drop mat
		rename temp mat
		
	
	* Impot pay
		gen irtot=F1P /* Impot immediat */
		gen irpv=ipp /* impot pv taux propor */
		gen iravantpv=irtot-irpv

	* Note: Attention: la base inclut les variables de la dclaration complmentaire et de la dclaration normale.

***********************************************************
*I)Traitements, salaires, pensions et rentes viagres  
***********************************************************
	
	foreach var of newlist sal_irpp chom_irpp frais_prof pension_irpp {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}

	* A) Salaires et chmages
	*************************
		* Pas de distinction entre sal et chom : on met tout dans sal et on utilisera seulement salchom
		replace sal_irpp=Z1AJ 
		replace chom_irpp=0

		replace sal_irpp_conj =  Z1BJ 
		replace chom_irpp_conj = 0
		
		* Frais pro
		replace frais_prof=Z1AK
		replace frais_prof_conj=Z1BK

	* B) Retraite
	**************
		* Inclue galement pensions alimentaires reues. Plus le cas  partir de 1999.
			replace pension_irpp=Z1AS
			replace pension_irpp_conj=Z1BS
			
	* C) Rentes viageres 
	**********************
		gen rente_irpp_foy=0
		local liste  A B C D
		foreach x of local liste {
				local liste2 U W Y
				foreach y of local liste2 {
					replace rente_irpp_foy= rente_irpp_foy+Z1`x'`y'
				}
		}

	* D)Personne  charge PAC
	****************************
		local liste C D E F
		foreach x of local liste {
			replace sal_irpp_pac= sal_irpp_pac + Z1`x'J  
			replace chom_irpp_pac= 0
			replace frais_prof_pac=frais_prof_pac + Z1`x'K
		}
		replace pension_irpp_pac= pension_irpp_pac+Z1CS+Z1DS+Z1RS+Z1TS

		
	* E) Au niveau foyer fiscal
	****************************
		gen sal_irpp_foy=sal_irpp+sal_irpp_conj+sal_irpp_pac
		gen chom_irpp_foy=chom_irpp+chom_irpp_conj+chom_irpp_pac
		gen frais_prof_foy=frais_prof+frais_prof_conj+frais_prof_pac
		gen pension_irpp_foy =pension_irpp+ pension_irpp_conj +pension_irpp_pac
		gen salchom_irpp_foy=sal_irpp_foy+ chom_irpp_foy
		drop Z1A* Z1B* Z1C* Z1D* Z1E* Z1F*

	
	
**************************************	
*II)  Revenus des capitaux mobiliers
**************************************	
		
		* A)Assurance-vie
		******************
			* Assurance-vie non declaree avant 1998
			* Bareme
				gen rfin_av_bar_irpp_foy = 0
			* PL
				gen rfin_av_pl_irpp_foy= 0
			* Total
				gen rfin_av_irpp_foy=rfin_av_bar_irpp_foy+rfin_av_pl_irpp_foy
		
		* B)Dividendes : 
		*****************
			* Au bareme 
				gen rfin_div_bar_irpp_foy = Z2DC +Z2ML
				gen rfin_div_bar_irpp_foy2 = Z2DC + Z2LZ*((10546284259-1385428895)/10546284259) +Z2ML
			* Au PL a partir de 2008
				gen rfin_div_pl_irpp_foy=0
			* Total
				gen rfin_div_irpp_foy=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy
				gen rfin_div_irpp_foy2=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy2		
			
		* C)Interets 
		**************
			* Bareme
				gen rfin_int_bar_irpp_foy= Z2GR + Z2LZ + Z2TR
				gen rfin_int_bar_irpp_foy2 = Z2GR + Z2LZ*(1385428895/10546284259)+ Z2TR
			* PL reporte seulement a partir de 2002
				gen rfin_int_pl_irpp_foy= 0
			* Total
				gen rfin_int_irpp_foy= rfin_int_bar_irpp_foy+ rfin_int_pl_irpp_foy
				gen rfin_int_irpp_foy2= rfin_int_bar_irpp_foy2+ rfin_int_pl_irpp_foy
		
		* D) Totaux 
		**************
				gen rfin_pl_irpp_foy=rfin_av_pl_irpp_foy+rfin_div_pl_irpp_foy+rfin_int_pl_irpp_foy
				gen rfin_bar_irpp_foy=rfin_av_bar_irpp_foy+rfin_div_bar_irpp_foy+rfin_int_bar_irpp_foy
				gen rfin_irpp_foy=rfin_av_irpp_foy+rfin_div_irpp_foy+rfin_int_irpp_foy

			* Note: Avant 2005, on remboursait l'IS prlev sur les dividendes via un avoir fiscal pour viter double imposition.
			* Systme a chang en 2005 en crant un abattement remplaant l'avoir fiscal
			drop Z2*	

*******************************
*III) Revenus non salaris
*******************************
* Remarque : les variables 5RE,SE,TE (bnfices) et 5RG,SG,TG (dficits)
* ne sont pas sur la 2042 mais sur la 2042G

	foreach var of newlist nonsal_irpp nonsalexo_irpp nonsal defnonsal_irpp microbic_vente microbic_serv microbnc {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}
		
		* A) Revenus non salaris exos
		*******************************
		* Creation des revenus exos avec les zones franches urbaines
		
		* Benef reel, transitoire ou dcla control avec ou sans CGA
			local liste F 
			foreach x of local liste {
				local liste2 S
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'
				}
			}
			local liste G 
			foreach x of local liste {
				local liste2 S
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'
				}
			}		
			local liste H
			foreach x of local liste {
				local liste2 S
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'
				}
			}	
			
			
			local liste J M 
			foreach x of local liste {
				local liste2 S A
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'
				}
			}
			local liste K N 
			foreach x of local liste {
				local liste2 S A
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'
				}
			}		
			local liste L P
			foreach x of local liste {
				local liste2 S A
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'
				}
			}
		
			local liste R 
			foreach x of local liste {
				local liste2 A
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'
				}
			}
			local liste S 
			foreach x of local liste {
				local liste2 A
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'
				}
			}
			local liste T
			foreach x of local liste {
				local liste2 A
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'
				}
			}
			
		* B)Revenus non salaris: benefice
		**************************************
			* On rajoute 25% pour centre non agr
				
			local liste R 
			foreach x of local liste {
				local liste2 H J K B E
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
				}
			}
			local liste S 
			foreach x of local liste {
				local liste2 H J K B E
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
				}
			}			
			local liste T
			foreach x of local liste {
				local liste2 H J K B E
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
				}
			}			
			
					
			local liste F
			foreach x of local liste {
				local liste2 T U
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25
				}
			}		
			local liste G
			foreach x of local liste {
				local liste2 T U
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25
				}
			}		
			local liste H
			foreach x of local liste {
				local liste2 T U
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25
				}
			}
								
			local liste J 
			foreach x of local liste {
				local liste2 T U
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25
				}
				local liste2 B C
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
				}
			}		
			local liste K 
			foreach x of local liste {
				local liste2 T U
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25
				}
				local liste2 B C
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
				}
			}		
			local liste L
			foreach x of local liste {
				local liste2 T U
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25
				}
				local liste2 B C
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
				}
			}
			
			local liste M
			foreach x of local liste {
				local liste2 T 
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25
				}
				local liste2 B C
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
				}
			}
			local liste N 
			foreach x of local liste {
				local liste2 T 
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25
				}
				local liste2 B C
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste P
			foreach x of local liste {
				local liste2 T 
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25
				}
				local liste2 B C
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
				}
			}
							
			local liste H
			foreach x of local liste {
				local liste2 J M 
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y' if ndecl==1
					replace nonsal_irpp=nonsal_irpp+0.5*Z5`x'`y' if ndecl==2
					replace nonsal_irpp_conj=nonsal_irpp_conj+0.5*Z5`x'`y' if ndecl==2
				}
			}
			local liste G
			foreach x of local liste {
				local liste2 J M 
				foreach y of local liste2 {
				    replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25 if ndecl==1
					replace nonsal_irpp=nonsal_irpp+0.5*Z5`x'`y'*1.25 if ndecl==2
					replace nonsal_irpp_conj=nonsal_irpp_conj+0.5*Z5`x'`y'*1.25 if ndecl==2
				}
			}
						
						
		* C) Revenus non salairs: plus-values voir section plus-value rfin_pv_pro_irpp_foy
		***************************************************************************************	

		* D)Revenus non salaris: dficits
		***********************************
			local liste R 
			foreach x of local liste {
				local liste2 D G
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste S 
			foreach x of local liste {
				local liste2 D G
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste T
			foreach x of local liste {
				local liste2 D G
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
				
			local liste F 
			foreach x of local liste {
				replace defnonsal_irpp=defnonsal_irpp+Z5`x'W
			}
			local liste G 
			foreach x of local liste {
				replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'W
			}
			local liste H
			foreach x of local liste {
				replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'W
			}
			
			
			local liste J 
			foreach x of local liste {
				local liste2 W X E
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste K 
			foreach x of local liste {
				local liste2 W X E
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste L
			foreach x of local liste {
				local liste2 W X E
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
						
			local liste M
			foreach x of local liste {
				local liste2 V E F
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}			
			local liste N
			foreach x of local liste {
				local liste2 V E F
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}			
			local liste P
			foreach x of local liste {
				local liste2 V E F
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
						
			local liste G H
				foreach x of local liste {
					local liste2 L
					foreach y of local liste2 {
						replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y' if ndecl==1			
						replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'/2 if ndecl==2
						replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'/2 if ndecl==2
					}
			}
							
			
		* E)Revenus non salaris: micro-fonciers et auto-entrepreneurs
		*************************************************************	
		* Recalcul du bnfice pour les auto-entrepreneurs et le rgime micro-entreprise (il faut dduire un abattement du chiffre d'affaire dclar pour retrouver le bnfice rel)
		* Les activits accessoires (tourisme et travaux forestiers) beneficient d'un abattement de 50% de 1996  1998 (checker avant). On les considre donc comme des micro bic (meme abattement)
	
			* Micro bic et autoentrepeneur : vente de marchandises
				* Avant 1999, pas de distinction entre BIC ventes de march et prest de services pour l'abattement
				local liste R  
				foreach x of local liste {
					local liste2 L M P
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste S 
				foreach x of local liste {
					local liste2 L M P
					foreach y of local liste2 {
						replace microbic_vente_conj=microbic_vente_conj+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste T 
				foreach x of local liste {
					local liste2 L M P
					foreach y of local liste2 {
						replace microbic_vente_pac=microbic_vente_pac+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				
			* Micro bic et autoentrepeneur : 
				* Inclus dans microbic_vente avant 1999
				
			* Micro bnc et autoentrepeneur bnc
				local liste R 
				foreach x of local liste {
					local liste2 N 
					foreach y of local liste2 {
						replace microbnc=microbnc+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				local liste S 
				foreach x of local liste {
					local liste2 N 
					foreach y of local liste2 {
						replace microbnc_conj=microbnc_conj+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				local liste T
				foreach x of local liste {
					local liste2 N 
					foreach y of local liste2 {
						replace microbnc_pac=microbnc_pac+Z5`x'`y' * (1-$tauxbnc)
					}
				}
			
						
			foreach var of varlist nonsal_irpp {
				replace `var'=`var'+microbnc+ microbic_serv+microbic_vente
				replace `var'_conj=`var'_conj+microbnc_conj+ microbic_serv_conj+microbic_vente_conj
				replace `var'_pac=`var'_pac+microbnc_pac+ microbic_serv_pac+microbic_vente_pac
			}
			foreach var of varlist nonsal {
				replace `var'=`var'_irpp+`var'exo_irpp
				replace `var'_conj=`var'_irpp_conj+`var'exo_irpp_conj
				replace `var'_pac=`var'_irpp_pac+`var'exo_irpp_pac
			}
							
			gen nonsal_irpp_foy=nonsal_irpp+nonsal_irpp_conj+nonsal_irpp_pac
			gen nonsalexo_irpp_foy=nonsalexo_irpp+nonsalexo_irpp_conj+nonsalexo_irpp_pac
			gen nonsal_foy=nonsal_irpp_foy+nonsalexo_irpp_foy
			
			
			
			
************************			
*IV)  Revenus fonciers
************************
		* Creation du rgime micro-foncier
		
		
		* A)Regime normal net de charges et intrts
		********************************************
			*en cas de benefices
				gen rfon_normal_irpp_foy=Z4CD
			* en cas de deficits: deficts catgoriels ou global
				gen rfon_defcat_foy= Z4CE
				gen rfon_defglo_foy=Z4CF
				
		* B) Regime micro-foncier brut
		******************************
			* CH reporte seulement les recettes brutes du micro-foncier. On dduit le taux d'abattement pour avoir le bnfice
			gen rfon_micro_irpp_foy= Z4CH *${tauxmicro_fon}
			
		gen rfon_irpp_foy=rfon_normal_irpp_foy+rfon_micro_irpp_foy
		drop Z4*

		
******************
* V) Plus value	 *	
******************


		gen rfin_pv_pro_irpp_foy=0
		gen rfin_mv_pro_irpp_foy=0
		gen rfin_pv_fon_irpp_foy=0
		gen rfin_pv_fin_irpp_foy=0
		gen rfin_mv_fin_irpp_foy=0
		gen rfin_pv_options_foy=0
		
		
		*A) Plus-values professionnelles
		********************************
		
			* Plus values
			
				replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z3VG /* Cession socit soumise  l'IR*/
				
				local liste R S T
				foreach x of local liste {
					local liste2 C F
					foreach y of local liste2 {
						replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
					}
				}
				local liste F G H 
				foreach x of local liste {
					local liste2 V
					foreach y of local liste2 {
						replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
					}
				}
				local liste J K L 
				foreach x of local liste {
					local liste2 D V
					foreach y of local liste2 {
						replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
					}
				}
				local liste M N P
				foreach x of local liste {
					local liste2 U D
					foreach y of local liste2 {
						replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
					}
				}
				local liste G H
				foreach x of local liste {
					local liste2 K
					foreach y of local liste2 {
						replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
					}
				}
				drop Z5*			

				

		* B) Plus-values foncires	
		***************************
			replace rfin_pv_fon_irpp_foy=rfin_pv_fon_irpp_foy+Z3VD + Z3VE + Z3VF
	
		*C) Plus-values financires
		***************************
		
			* Regime normal + pv de PEA clotur avant 2 ans + pv capital risque 
				local liste   V
				foreach x of local liste {
					local liste2  H K N P
					foreach y of local liste2 {
						replace rfin_pv_fin_irpp_foy=rfin_pv_fin_irpp_foy+Z3`x'`y'
					}
					local liste2  J L
					foreach y of local liste2 {
						replace rfin_mv_fin_irpp_foy=rfin_mv_fin_irpp_foy+Z3`x'`y'
					}
				}
			* Stock options :
				replace rfin_pv_options_foy=rfin_pv_options_foy+Z3VM
				local liste   T U
				foreach x of local liste {
					local liste2  W X Y
					foreach y of local liste2 {
						replace rfin_pv_options_foy=rfin_pv_options_foy+Z1`x'`y'
					}
				}
							
			gen rfin_pv_irpp_foy=rfin_pv_fin_irpp_foy+rfin_pv_fon_irpp_foy+rfin_pv_pro_irpp_foy+rfin_pv_options_foy
			gen rfin_mv_irpp_foy=rfin_mv_fin_irpp_foy+rfin_mv_pro_irpp_foy
			drop  Z3* Z1*
	
		
		
***************************************************************************************
	keep year pondn-rfin_mv_irpp_foy
		drop micro* 
		gen idfoy=_n
		#delimit;
			order year idfoy pondn ndecl  age agec sexe mat  npac  anaispac* 
			salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
			rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy rfin_int_irpp_foy2 rfin_int_bar_irpp_foy rfin_int_bar_irpp_foy2 rfin_int_pl_irpp_foy rfin_div_irpp_foy rfin_div_irpp_foy2 rfin_div_bar_irpp_foy rfin_div_bar_irpp_foy2 rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
			rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
			#delimit cr
		save "$wfrev/rev${year}.dta",replace
		
	
